package com.agilex.healthcare.veteranappointment.datalayer.patient;

import com.agilex.healthcare.veteranappointment.datalayer.Transformable;
import com.agilex.healthcare.veteranappointment.domain.VARPatientPreference;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "NOTIFICATION_PREFERENCE")
public class NotificationPreferencePo implements Transformable<VARPatientPreference> {
	
	private String patientId;
    private String notificationFrequency;
    private String emailAddress;
    private String textMessagePhoneNumber;
    private boolean emailAllowed;
    private boolean textMessageAllowed;
    
    public NotificationPreferencePo() {}
    
    public NotificationPreferencePo(VARPatientPreference dto){
    	setPatientId(dto.getPatientId());
    	setNotificationFrequency(dto.getNotificationFrequency());
    	setEmailAddress(dto.getEmailAddress());
    	setEmailAllowed(dto.isEmailAllowed());
    	setTextMessagePhoneNumber(dto.getTextMsgPhNumber());
    	setTextMessageAllowed(dto.isTextMsgAllowed());
    }
    
    @Id
    @Column(name="PATIENT_ID")
	public String getPatientId() {
		return patientId;
	}
	public void setPatientId(String patientId) {
		this.patientId = patientId;
	}
	
	@Column(name="NOTIFICATION_FREQUENCY")
	public String getNotificationFrequency() {
		return notificationFrequency;
	}
	public void setNotificationFrequency(String notificationFrequency) {
		this.notificationFrequency = notificationFrequency;
	}
	
	@Column(name="EMAIL_ADDRESS")
	public String getEmailAddress() {
		return emailAddress;
	}
	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}
	
	@Column(name="TEXT_MESSAGING_PHONE_NUMBER")
	public String getTextMessagePhoneNumber() {
		return textMessagePhoneNumber;
	}
	public void setTextMessagePhoneNumber(String textMessagePhoneNumber) {
		this.textMessagePhoneNumber = textMessagePhoneNumber;
	}
	
	@Column(name="EMAIL_ALLOWED")
	public boolean isEmailAllowed() {
		return emailAllowed;
	}
	public void setEmailAllowed(boolean emailAllowed) {
		this.emailAllowed = emailAllowed;
	}
	
	@Column(name="TEXT_MESSAGING_ALLOWED")
	public boolean isTextMessageAllowed() {
		return textMessageAllowed;
	}
	public void setTextMessageAllowed(boolean textMessageAllowed) {
		this.textMessageAllowed = textMessageAllowed;
	}
    
	@Override
	public VARPatientPreference create() {
        VARPatientPreference patientPreference = new VARPatientPreference();
		
		patientPreference.setPatientId(getPatientId());
		patientPreference.setNotificationFrequency(getNotificationFrequency());
		patientPreference.setEmailAddress(getEmailAddress());
		patientPreference.setEmailAllowed(isEmailAllowed());
		patientPreference.setTextMsgPhNumber(getTextMessagePhoneNumber());
		patientPreference.setTextMsgAllowed(isTextMessageAllowed());
		
		return patientPreference;
	}
}
